program search_in_file;
uses
  CRT, FileUtil, SysUtils, OutScr;
type
    manager= record
    name: string[18];
    comp: integer;
 end;
var
  company: manager;
  f_not_sorted, f_sorted: File of manager;
  vector: array of manager;
  i, n: integer;
  name_file: string;
  name_manager: string;
  { =============    Бинарный поиск ======== }
function BinarySearch(var a: array of manager;
                      name_manager: string): integer;
var
  left, right, middle: integer;
begin
  left:= Low(a);
  right:= High(a);
  repeat
  middle:= (left + right) div 2;
  if name_manager < a[middle].name then
    right:= middle - 1
  else
    if name_manager > a[middle].name then
      left:= middle + 1
    else
    begin
      BinarySearch:= middle;
      exit;
    end;
  until left > right;
  BinarySearch:= -1;
end;
{  ====================================================== }
begin
  {При необходимости укажите полный путь к файлу
   или скопируйте файл в папку с данным проектом}
  if not FileExists('File_not_sorted.dat') then
  begin
    writeln(UTF8ToConsole('Файлы не существуют'));
    writeln(UTF8ToConsole('Сначала создайте их'));
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    exit;
  end;
  AssignFile(f_sorted,'File_sorted.dat');
  Reset(f_sorted);
  n:= System.FileSize(f_sorted); // Определение количества записей в файле
  SetLength(vector, n);
  {Подготовка к поиску,
  считывание записей файла в массив,
  в функцию передается массив, а не файл.}
  i:= 0;
  while not Eof(f_sorted) do
  begin
     Read(f_sorted, company);
     vector[i]:= company;  // массив, который будет сортироваться
     i:= i + 1;
  end;
  CloseFile(f_sorted);
  writeln(UTF8ToConsole('Введите фамилию менеджера'));
  readln(name_manager);
  {вызов функции поиска}
  n:= BinarySearch(vector, name_manager);
  name_file:= 'File_sorted.dat';
  {Вызов процедуры для вывода на экран сводной ведомости.
  Процедура находится в модуле OutScr}
  output_to_screen(name_file);
   if n= -1 then
     writeln(UTF8ToConsole('Такого менеджера нет'))
  else
     writeln(UTF8ToConsole('Менеджер найден, его номер в файле '), n+1);
  write(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.

